/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class HeightSpawnCriteria
extends SpawnCriteria {
    public static final Codec<HeightSpawnCriteria> CODEC = RecordCodecBuilder.create(heightSpawnCriteriaInstance -> heightSpawnCriteriaInstance.group((App)Codec.INT.fieldOf("min_height").forGetter(HeightSpawnCriteria::getMinHeight), (App)Codec.INT.fieldOf("max_height").forGetter(HeightSpawnCriteria::getMaxHeight), (App)Codec.INT.optionalFieldOf("check_size", (Object)16).forGetter(HeightSpawnCriteria::getCheckSize)).apply((Applicative)heightSpawnCriteriaInstance, HeightSpawnCriteria::new));
    private final int minHeight;
    private final int maxHeight;
    private final int checkSize;

    public HeightSpawnCriteria(int minHeight, int maxHeight, int checkSize) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.checkSize = checkSize;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.HEIGHT.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        int lowestY = this.getLowestY(chunkPos, chunkGenerator, heightAccessor);
        return lowestY > this.minHeight && lowestY < this.maxHeight;
    }

    private int getLowestY(ChunkPos chunkPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int[] aint = this.getCornerHeights(i - this.getCheckSize() / 2, i + this.getCheckSize() / 2, j - this.getCheckSize() / 2, j + this.getCheckSize() / 2, chunkGenerator, heightAccessor);
        return Math.min(Math.min(aint[0], aint[1]), Math.min(aint[2], aint[3]));
    }

    private int[] getCornerHeights(int x0, int z0, int x1, int z1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        return new int[]{chunkGenerator.m_156179_(x0, x1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0, x1 + z1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0 + z0, x1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0 + z0, x1 + z1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor)};
    }

    protected int getMinHeight() {
        return this.minHeight;
    }

    protected int getMaxHeight() {
        return this.maxHeight;
    }

    protected int getCheckSize() {
        return this.checkSize;
    }
}

